/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

Resource Manager

------------------------------------------------------------------------ */

#ifndef RMPME_H
#define RMPME_H

// Includes and defines and forward definitions
#include "MemoryManager.h"
#define PME_RESOURCES "game.cdc"

// Resources offered by the RM
#define RM_PANEL_MENU   0xAA000
#define RM_PANEL_GAME   0xAA001

#define RM_FONT_CONSOLE 0xAB000
#define RM_FONT_INFO    0xAB001
#define RM_FONT_SCORE   0xAB002

#define RM_MUS_MENU     0xAC000
#define RM_MUS_GAME     0xAC001

#define RM_SND_THUNDER		0xAD001
#define RM_SND_CLICKOK		0xAD002
#define RM_SND_CLICKCANCEL	0xAD003
#define RM_SND_CLICKCANCEL2 0xAD004
#define RM_SND_EXIT			0xAD005
#define RM_SND_GAMEABORT	0xAD006
#define RM_SND_GAMEOVER     0xAD007 
#define RM_SND_GAMESTARTING	0xAD008
#define RM_SND_GAMEPLAYERDEATH		0xAD009
#define RM_SND_GAMEEATPELLET		0xAD010
#define RM_SND_GAMEEATPELLETPOWER	0xAD011
#define RM_SND_GAMEEATGHOST     	0xAD012

#define RM_IMG_ICON	0xAE000
#define RM_IMG_MENU	0xAE001
#define RM_IMG_HOF	0xAE002

#define RM_SPR_PACMAN		0xBA000
#define RM_SPR_GHOSTRED		0xBA002
#define RM_SPR_GHOSTPINK	0xBA003
#define RM_SPR_GHOSTBLUE	0xBA004
#define RM_SPR_GHOSTORANGE	0xBA005
#define RM_SPR_PELLET		0xBA006
#define RM_SPR_PELLETPOWER	0xBA007
#define RM_SPR_TARGETS      0xBA008

// Widget IDs
#define ID_EXIT             0xDF00
#define ID_STANDARDGAME     0xDF01
#define ID_EVOLUTIONGAME    0xDF02
#define ID_WORKBENCHGAME    0xDF03
#define ID_HALLOFFAME       0xDF05
#define ID_GAME_LABEL       0xDF06
#define ID_GAME_ENTERNAME   0xDF07
#define ID_GAME_CLOSE       0xDF08

// ResourceManager class implemented as a singleton
class ResourceManager : public CMemPME
{
public:
    static ResourceManager& Instance(); // Singleton accessor by object reference
    static void Terminate(); // Explicit singleton destruction

    Sint32 load();
    Sint32 free();
    Sint32 get(Sint32 iID) const;
    Sint32 setPacManDeathAnim(Sint32);

private:
    ResourceManager(); // Heap-based and stack-based creation are forbidden.
    ~ResourceManager(); // Inheritance is also forbidden.
    static ResourceManager* mInstance;

    // Flag for controlling the PacMan death animation
    Sint32 bPacManDeathAnim;

	// Panels
	Sint32 guiMenu, guiGame;
	
	// Fonts
	Sint32 fntConsole, fntInfo, fntScore;

	// Music
	Sint32 musMenu[3];
	Sint32 musGame[4];

	// Sounds
	Sint32 sndThunder, sndClickOK, sndClickCancel, sndClickCancel2, sndExit;
	Sint32 sndGameAbort, sndGameOver, sndGameStarting, sndGamePlayerDeath, sndGameEatPellet, sndGameEatPelletPower, sndGameEatGhost;

    // Images
    Sint32 imgIcon, imgMenu, imgHallOfFame;

    // Cursors
    Sint32 curArrow;
    
    // Sprites
	Sint32 sprPacman, sprGhostRed, sprGhostPink, sprGhostBlue, sprGhostOrange, sprTargets;
	Sint32 sprPellet, sprPelletPower;
};

#endif
