/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

Pac-Man Evolution

Pac-Man clone. Main features:
- 2D environment
- 1024x768 with 32bits
- Highscore table
- 1 player
- Procedural and deterministic mazes creation algorithm
- Ghosts team IA using neural networks trained with genetic algorithms

Changelog:
- Check History.txt

------------------------------------------------------------------------ */

#ifndef PACMANEVOLUTION_H
#define PACMANEVOLUTION_H

// Includes
#include "MemoryManager.h"

// Defines
#define GAME_VERSION "Pac-Man Evolution 1.0.2"

#define PME_BREAK     -1
#define PME_LOOP       0
#define PME_ENTRY      1
#define PME_MAZE_END   2
#define PME_GAME_OVER  4
#define PME_GAME_STANDARD    8
#define PME_GAME_EVOLUTION   16
#define PME_GAME_WORKBENCH   32
#define PME_HOF       64
#define PME_EXIT     256

#define PME_SCREEN_MENU 0
#define PME_SCREEN_HOF  1
#define PME_SCREEN_GAME 2
#define PME_LOGIC_RATE 40

//#define PME_WORKBENCH_ENABLED // Enable the training mode

// Global status struct
struct GlobalStatus
{
    GlobalStatus();
    ~GlobalStatus();
    Sint32 clear();

    Sint32 iRenderScreen;   // PME_SCREEN_MENU, PME_SCREEN_HOF or PME_SCREEN_GAME
    char szName[8];         // Name of player, by default set to PacMan string. 
    Sint32 iPoints;         // Store PacMan score across all the mazes.
    Sint32 iGameType;       // Game type: standard or evolution.
    Sint32 iHighestScore;   // Game type highest score.
    Sint32 iLowestScore;    // Game type lowest score.
    
    // Workbench
    struct WorkBench
    {
        Sint32 iTraining;   // Training mode (0 disabled and 1 enabled)
        Sint32 iExecutions; // Number of executions, by default 100.
        Sint32 iSpeed;      // 1 for realtime, 2 for 2x, etc.
        Sint32 iTime;       // Maximum playing time in seconds per maze (0 for no limit)
        char szOutputCSV[255];
        Sint32 iPacManBrain;
        Sint32 iGhostRedBrain;
        Sint32 iGhostPinkBrain;
        Sint32 iGhostBlueBrain;
        Sint32 iGhostOrangeBrain;
    } workBench;    
};

// MazePoint struct
struct MazePoint : public CMemPME
{
    Sint32 iX;
    Sint32 iY;
    double dDistance;
    Sint32 iReserved;
};

// Points
#define PME_POINTS_EAT_PELLET       10 
#define PME_POINTS_EAT_PELLET_POWER 50 
#define PME_POINTS_EAT_GHOST        200 

// Maze global vars
#define MAZE_WIDTH       28
#define MAZE_HEIGHT      31
#define MAZE_TILE_SIZE   24

#endif
