/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

PacMan and states classes

------------------------------------------------------------------------ */

#ifndef OBJECTSPACMANPME_H
#define OBJECTSPACMANPME_H

// Includes and forward definitions
#include "Objects.h"

// Init State
class PacManStateInit : public State
{
public:
    explicit PacManStateInit(const string&);
    void enter(Actor*);
    void execute(Actor*);
    void exit(Actor*);
private:
    Uint64 iTime;
};

// Evading State
class PacManStateEvading : public State
{
public:
    explicit PacManStateEvading(const string&);
    void execute(Actor*);
private:
    Sint32 iTX, iTY, iITX, iITY;
    bool bGetNewTarget;
};

// Chasing State
class PacManStateChasing : public State
{
public:
    explicit PacManStateChasing(const string&);
    void enter(Actor*);
    void execute(Actor*);
    void exit(Actor*);
private:
    Sint32 iTicks;
};

// Death State
class PacManStateDeath : public State
{
public:
    explicit PacManStateDeath(const string&);
    void enter(Actor*);
    void execute(Actor*);
};

// Pac-Man class
class PacMan : public Actor
{
    // State classes can access to all attributes
    friend class PacManStateInit;
    friend class PacManStateEvading;
    friend class PacManStateChasing;
    friend class PacManStateDeath;

public:
    PacMan(Sint32 iMX, Sint32 iMY, GameField* GF);
    ~PacMan();
    Sint32 execute();    
    Sint32 debug(Sint32);    
    Sint32 getLifes();

    // Messages that modified our state
    Sint32 msgGoInit();
    Sint32 msgPelletPowerEaten(Sint32, Sint32);
    Sint32 msgGhostCollision();

private:
    // Methods
    Sint32 applyMovementRules(Sint32, Sint32);

    // Attributes
    Sint32 iLifes;  // Lifes.
    Sint32 iPointsForEatingGhostsPerPelletPower;    // With each power pellet, eating ghosts give us PME_PACMAN_POINTS_EAT_GHOST points

    // PacMan states
    PacManStateInit* pStateInit;
    PacManStateEvading* pStateEvading;
    PacManStateChasing* pStateChasing;
    PacManStateDeath* pStateDeath;
};

#endif
