/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

Ghost class

------------------------------------------------------------------------ */

#ifndef OBJECTSGHOSTPME_H
#define OBJECTSGHOSTPME_H

// Includes and forward definitions
#include "Objects.h"

// Init State
class GhostStateInit : public State
{
public:
    explicit GhostStateInit(const string&);
    void enter(Actor*);
    void execute(Actor*);
private:
    Uint64 iTime;
};

// Evading State
class GhostStateEvading : public State
{
public:
    explicit GhostStateEvading(const string&);
    void enter(Actor*);
    void execute(Actor*);
    void exit(Actor*);
};

// Chasing State
class GhostStateChasing : public State
{
public:
    explicit GhostStateChasing(const string&);
    void enter(Actor*);
    void execute(Actor*);
    void exit(Actor*);
private:
    Sint32 iTX, iTY, iITX, iITY;
    bool bGetNewTarget;
};

// Scattering State
class GhostStateScattering : public State
{
public:
    explicit GhostStateScattering(const string&);
    void enter(Actor*);
    void execute(Actor*);
    void exit(Actor*);
};

// Death State
class GhostStateDeath : public State
{
public:
    explicit GhostStateDeath(const string&);
    void enter(Actor*);
    void execute(Actor*);
    void exit(Actor*);
};

// Ghost class
class Ghost : public Actor
{
    // State classes can access to all attributes
    friend class GhostStateInit;
    friend class GhostStateEvading;
    friend class GhostStateChasing;
    friend class GhostStateScattering;
    friend class GhostStateDeath;

public:
    Ghost(Sint32 iObjID, Sint32 iMX, Sint32 iMY, GameField* GF);
    ~Ghost();
    Sint32 execute();
    Sint32 debug(Sint32);
    
    // Messages that modified our state
    Sint32 msgGoInit();
    Sint32 msgPelletPowerEaten(Sint32, Sint32);
    Sint32 msgGhostCollision();     

    // Get Scattering predefined target
    Sint32 getScatteringTarget(Sint32&, Sint32&);

protected:
    // Protected methods
    Sint32 applyMovementRules(Sint32, Sint32);    

    // Attributes
    Sint32 iGoingOutTrigger;    
    MazePoint pointEvadingTarget;
    MazePoint pointScatteringTarget;
    
    // Ghost states
    GhostStateInit* pStateInit;
    GhostStateEvading* pStateEvading;
    GhostStateChasing* pStateChasing;
    GhostStateScattering* pStateScattering;
    GhostStateDeath* pStateDeath;
};

#endif
