/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

Menu class

------------------------------------------------------------------------ */

#include "Menu.h"
#include "ResourceManager.h"
#include "Pac-Man_Evolution.h"

Menu::Menu()
{
}

Menu::~Menu()
{
}

// Process the widget events and call associated handlers
// Return PME_LOOP, PME_BREAK or PME_EXIT
Sint32 Menu::processEvent(const Sint32 idWidget, const Sint32 iValue)
{
    Panel* pPanel = Main::Instance().IGUIMgr().getPanel(ResourceManager::Instance().get(RM_PANEL_MENU));
    Main& mC64 = Main::Instance();
    Sint32 iRet = PME_LOOP;

    // Manage our events
    switch(idWidget)
    {
    case ID_EXIT:
        mC64.IAudioTrackMgr().get(ResourceManager::Instance().get(RM_SND_CLICKOK))->play();
        iRet = PME_EXIT;
        break;
    case ID_STANDARDGAME:
        mC64.IAudioTrackMgr().get(ResourceManager::Instance().get(RM_SND_CLICKOK))->play();
        iRet = PME_GAME_STANDARD;
        break;
    case ID_EVOLUTIONGAME:
        mC64.IAudioTrackMgr().get(ResourceManager::Instance().get(RM_SND_CLICKOK))->play();
        iRet = PME_GAME_EVOLUTION;
        break;
    case ID_WORKBENCHGAME:
        mC64.IAudioTrackMgr().get(ResourceManager::Instance().get(RM_SND_CLICKOK))->play();
        iRet = PME_GAME_WORKBENCH;
        break;
    case ID_HALLOFFAME:
        mC64.IAudioTrackMgr().get(ResourceManager::Instance().get(RM_SND_CLICKOK))->play();
        iRet = PME_HOF;
        break;    
    }      

    return iRet;
}

// Render method
Sint32 Menu::render(Sint32 iMode)
{
    SDL_FRect rDst;
    Sint32 iSW = 0, iSH = 0;
    Screen* pScreen = Main::Instance().IConfigMgr().get();
    if(pScreen != nullptr) pScreen->getSize(&iSW, &iSH);

    // Render background centered
    Image* pImage = Main::Instance().IImageMgr().get(ResourceManager::Instance().get(RM_IMG_MENU));
    if(pImage != nullptr)
    {
        rDst.w = (float)pImage->getSurface()->w;
        rDst.h = (float)pImage->getSurface()->h;
        rDst.x = (float)(iSW - pImage->getSurface()->w) / 2.0f;
        rDst.y = (float)(iSH - pImage->getSurface()->h) / 2.0f;
        pImage->render(0, nullptr, &rDst);
    }
    return PME_LOOP;
}