/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

Memory Manager

------------------------------------------------------------------------ */

#ifndef MEMORYMANAGERPME_H
#define MEMORYMANAGERPME_H

// Includes
#if __has_include(<CRM64Pro/CRM64Pro.h>)
 #include <CRM64Pro/CRM64Pro.h>
#else
 #include <CRM64Pro.h>
#endif
using namespace CRM64Pro;

// Enable or disable the memory manager
#define USE_CMEM

// Use of CMem memory manager
#ifdef USE_CMEM
class CMemPME
{
public:
    // These are the only needed operators. It could be extended if needed.
    void* operator new(size_t, const std::nothrow_t&);
    void operator delete(void*, const std::nothrow_t&);
    void operator delete(void*);
};
    #define _PME_ALLOC(type,size) (type*)CRM64Pro::CMem::alloc(sizeof(type) * (size), 1)
    #define _PME_FREE(p) CRM64Pro::CMem::free(p)
#else
    class CMemPME {};
    #define _PME_ALLOC(type, size) new(std::nothrow) type[size]
    #define _PME_FREE(p) delete[]p
#endif
    
#endif
