/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

Memory Manager

------------------------------------------------------------------------ */

// Includes
#include "MemoryManager.h"

// CMemPME class implementation
#ifdef USE_CMEM
void* CMemPME::operator new(size_t iSize, const std::nothrow_t& n)
{
    void* pMem = CMem::alloc(iSize, 1);
    return pMem;
}
void CMemPME::operator delete(void* pMem, const std::nothrow_t& n)
{
    CMem::free(pMem);
}
void CMemPME::operator delete(void* pMem)
{
    CMem::free(pMem);
}
#endif