/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

MazeGenerator class

Based on Shaun LeBron code (https://github.com/shaunlebron/pacman-mazegen) using "tetris" variant.

------------------------------------------------------------------------ */

#ifndef MAZEDYNAMICPME_H
#define MAZEDYNAMICPME_H

// Includes and forward definitions
#include "MemoryManager.h"

//#define DEBUG_GENERATOR

// rows = 9
// col = 5

class Maze : public CMemPME
{
public:
    Maze(Sint32 iR, Sint32 iC);
    ~Maze();
    Sint32 createMaze(vector<Uint8>&);

private:
    // Cell definition and cells array
    struct stCell
    {
        Sint32 x, y;
        bool filled;
        bool connect[4];
        stCell* next[4];
        Sint32 no;
        Sint32 group;
        // Internal vars
        Sint32 final_x, final_w;
        Sint32 final_y, final_h;
        // Auxiliar flags
        bool isRaiseHeightCandidate;
        bool isShrinkWidthCandidate;
        bool shrinkWidth;
        bool raiseHeight;
        bool isJoinCandidate;
        bool topTunnel;
        bool singleDeadEndDir;
        bool isEdgeTunnelCandidate;
        bool isVoidTunnelCandidate;
        bool isSingleDeadEndCandidate;
        bool isDoubleDeadEndCandidate;
        stCell();
        #ifdef DEBUG_GENERATOR
        void info();
        #endif
    };
    vector<stCell> vCells;

    // Internal vars
    Sint32 tallRows[50];
    Sint32 narrowCols[50];
    Sint32 rows;
    Sint32 cols;    
    Sint32 numFilled;  // current count of total cells filled
    Sint32 numGroups;  // current count of cell groups created

    // Private methods

    // Random stuff
    Sint32 iNumRands;
    Sint32 getRandomInt(Sint32, Sint32); 
    double getRandomReal();
    Sint32 suffle(vector<stCell*>&);
    stCell* randomElement(vector<stCell*>&);
    Uint32 randSeed[16];
    Uint32 randState;

    // Maze generation stuff
    Sint32 reset(); // Reset the map
    void getOpenCells(stCell&, Sint32, Sint32, vector<Sint32>&);
    Sint32 getLeftMostEmptyCells(vector<stCell*>&);
    bool isOpenCell(stCell& c, Sint32 i, Sint32 prevDir = -1, Sint32 size = -1);
    void connectCell(stCell&, Sint32);
    void setResizeCandidates();
    bool cellIsCrossCenter(stCell&);
    bool canShrinkWidth(Sint32, Sint32);
    bool chooseNarrowCols();
    bool canRaiseHeight(Sint32, Sint32);
    bool chooseTallRows();
    bool isHori(Sint32, Sint32);
    bool isVert(Sint32, Sint32);
    bool isDesirable();
    void setUpScaleCoords();
    void reassignGroup(Sint32, Sint32);
    void joinWalls();
    void fillCell(stCell&);
    void selectSingleDeadEnd(stCell*);
    void replaceGroup(Sint32, Sint32);
    bool createTunnels();
    void generate();

    // Convert maze to "tiles" stuff    
    vector<stCell> tileCells; // Todo rename
    Sint32 subrows, subcols;
    Sint32 midcols, fullcols;
    void setTile(Sint32 x, Sint32 y, Uint8 v, vector<Uint8>&);
    Sint32 getTile(Sint32, Sint32, vector<Uint8>&);
    void setTileCell(Sint32, Sint32, stCell&);
    stCell* getTileCell(Sint32, Sint32);
    bool getTopEnergizerRange(Sint32&, Sint32&, vector<Uint8>&);
    bool getBotEnergizerRange(Sint32&, Sint32&, vector<Uint8>&);
    void eraseUntilIntersection(Sint32, Sint32, vector<Uint8>&);
    Sint32 generateTiles(vector<Uint8>&);
};

#endif