/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

Hall of Fame class

------------------------------------------------------------------------ */

#ifndef HOFPME_H
#define HOFPME_H

// Includes and forward definitions
#include "MemoryManager.h"
#define PME_CONFIG "setup.cdc"
#define PME_HOF_SCORES 10

class HoF : public CMemPME
{
public:
    explicit HoF();
    ~HoF();
    Sint32 store(Sint32 iGameType, Sint32 iPoints, char* szName);
    Sint32 render(Sint32 iMode);
    Sint32 getHighest(Sint32 iGameType);
    Sint32 getLowest(Sint32 iGameType);

private:
    Sint32 insert(Sint32 iGameType, Sint32 iPos, Sint32 iPoints, char* szName);
    
    struct sScores
    {
        char	sName[8];
        Sint32  iPoints;
    } scores[2][PME_HOF_SCORES]; // Game top 10 scores on the two modes: standard and evolution
};


#endif