/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

GameField class

------------------------------------------------------------------------ */

#ifndef GAMEFIELDPME_H
#define GAMEFIELDPME_H

// Flags for debugging
//#define DEBUG_INTERNAL

// Includes and forward definitions
#include "MemoryManager.h"
#include "Pac-Man_Evolution.h"
class Maze;
class MapSearchAStar;
class Object;
class EVNTrainer;
class Actor;

#define PME_STATE_NULL              0
#define PME_STATE_WALL              1
#define PME_STATE_WALKABLE_GHOST    2
#define PME_STATE_WALKABLE          4

#define PME_ITEM_NULL           0 
#define PME_ITEM_PELLET         1

#define PME_OBJECT_NULL             0
#define PME_OBJECT_PACMAN           1
#define PME_OBJECT_GHOST_RED        2
#define PME_OBJECT_GHOST_PINK       4
#define PME_OBJECT_GHOST_BLUE       8
#define PME_OBJECT_GHOST_ORANGE     16
#define PME_OBJECT_PELLET_POWER1    32
#define PME_OBJECT_PELLET_POWER2    64
#define PME_OBJECT_PELLET_POWER3    128
#define PME_OBJECT_PELLET_POWER4    256

#define PME_GET_PELLET(x) ((x) & 0x1E0)

#define PME_ACTOR_ALIVE     PME_LOOP 
#define PME_ACTOR_SPECIAL   1

#define PME_GLOBAL_WAVE_CHASING     1
#define PME_GLOBAL_WAVE_SCATTERING  2
#define PME_GLOBAL_WAVE_EVADING     4
#define PME_GLOBAL_WAVE_EVADING_END 8

#define RENDERGRAPHICS_START 0
#define RENDERGRAPHICS_GAME  1

// Debug output
#define PME_DEBUG_PANEL_GAMEFIELD_X 8
#define PME_DEBUG_PANEL_GAMEFIELD_Y 0
#define PME_DEBUG_PANEL_PACMAN_X 8
#define PME_DEBUG_PANEL_PACMAN_Y 112
#define PME_DEBUG_PANEL_GHOST_X 8
#define PME_DEBUG_PANEL_GHOST_Y 224

// GameField class
class GameField : public CMemPME
{
    friend class EVNTrainer;
public:
    GameField(GlobalStatus* GS);
    ~GameField();
    Sint32 init();
    Sint32 nextMaze();
    Sint32 close();
    Sint32 execute();
    Sint32 render(Sint32 iMode);       

    MapSearchAStar& mapSearch();
    Sint32 getState(Sint32 iMX, Sint32 iMY);
    Sint32 getItem(Sint32 iMX, Sint32 iMY);
    Sint32 getEatenPelletsPercent();
    Sint32 getObjectPosition(Sint32, Sint32&, Sint32&);
    Sint32 getObjectDirection(Sint32, Sint32&, Sint32&);
    Sint32 getObjectStateName(Sint32, string&);
    Sint32 getClosestPellet(Sint32, Sint32&, Sint32&);
    Sint32 moveTo(Sint32, Sint32, Sint32, Sint32, Sint32);
    Sint32 messageGetReady(Sint32 iShow);
    Sint32 initObjects(); 
    Sint32 validateMazePosition(Sint32&, Sint32&);
    Sint32 getMovementOptions(Sint32, Sint32, vector<MazePoint>&);
    Sint32 getWaveMode();
    Sint32 setWaveMode(Sint32);
    Sint32 restoreWaveMode();
      
private:            
    // GlobalWave vars
    struct sGlobalWave
    {
        Sint32 update();
        Sint32 reset();

        Sint32 iMode;
        Sint32 iPreviousMode;
        Sint32 iTicks;
        Sint32 iChanges;
    } sGlobalWave;

    // General methods
    Sint32 messageStart();      // Show a message at the beginning of each maze
    Sint32 messageEnd(Sint32);    // Show a message at the end of the game
    Sint32 specialText(Font* pFont, Sint32 iX, Sint32 iY, string &sText, Sint32 iCount);  
    Sint32 debug();             // Show debug information on game screen
    Sint32 addPoints(Sint32 iP);
   
    // General attributes
    Uint64 iTimeStart;
    Sint32 iMazeReady, iGetReadyTime;
    Sint32 iNumPellets, iNumEatenPellets;    
    Sint32 iMazePixelX, iMazePixelY; // Start maze rendering coordinates, auto-adapt to screen resolution
    template <typename T>  T **create2DArray(Sint32 height, Sint32 width); // Taken from CRM64Pro
    template <typename T>  Sint32  delete2DArray(T** Array); // Taken from CRM64Pro
    struct sField
    {
        Sint32 iState;
        Sint32 iItem;
        Sint32 iObject;
        Sint32 iReserved;
    };
    sField **iFieldArray; // Dynamic 2D array [y][x]

    // Vector with objects
    vector<Object*> vObjects;
    Sint32 getObjectIndex(Sint32);
    
    // Used by EVNTrainer
    Actor* getActor(Sint32); 
    Sint32 getMazeNumber();

    // Special messages (start game, end game, add points, etc.) vars
    Sint32 iRenderGraphicsStatus;
    Sint32 iSpecialTextCounter;
    string sSpecialMessageCounter;
    string sSpecialMessage;
        
    // Debug stuff
    Sint32 bDebug;
    Sint32 iDebugMode; 
    Sint32 bDebugDisableObjectRender;
    Sint32 bDebugShowTarget;
    Sint32 iMazeDynamicGenerationTime;
    Sint32 iMazeDynamicGenerationAttemps;

    // Internal components
    Maze* pMazeGen;
    MapSearchAStar* pMapSearch;

    // Pointer to needed components
    GlobalStatus* pGlobalStatus;  
};

#endif
