/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

EVolution Neural Trainer

------------------------------------------------------------------------ */

#ifndef EVNTRAINER_H
#define EVNTRAINER_H

#define DEBUG_EVN

// Includes and forward definitions
#include "MemoryManager.h"
#include "ArtificialNeuralNet.h"
class GameField;
struct GlobalStatus;
class GeneticAlgorithm;
struct Genome;
class BrainEvolved;

#define PME_GHOSTS_NN_FILE "neuralnet.cdc"
#define PME_GHOSTS_NN_BLOCK "ghosts.xml"

#define PME_GA_CROSSOVER_RATE	0.7
#define PME_GA_MUTATION_RATE	0.2
#define PME_GA_MAX_PERTURBATION 0.4
#define	PME_GA_NUM_ELITE        2
#define PME_GA_NUM_COPIES_ELITE	2
#define PME_GA_POPULATION       15 // Match PME_BRAIN_TYPE_TRAININGx defined in BrainsFactory.h

#define PME_ANN_GHOST_RED_INPUT         2
#define PME_ANN_GHOST_RED_HIDDEN        0
#define PME_ANN_GHOST_RED_ACTIVATION    ANN_ACTIVATION_SIGMOID 

#define PME_ANN_GHOST_PINK_INPUT        4
#define PME_ANN_GHOST_PINK_HIDDEN       3
#define PME_ANN_GHOST_PINK_ACTIVATION   ANN_ACTIVATION_SIGMOID 

#define PME_ANN_GHOST_BLUE_INPUT        3
#define PME_ANN_GHOST_BLUE_HIDDEN       2
#define PME_ANN_GHOST_BLUE_ACTIVATION   ANN_ACTIVATION_SIGMOID 

#define PME_ANN_GHOST_ORANGE_INPUT      3
#define PME_ANN_GHOST_ORANGE_HIDDEN     0
#define PME_ANN_GHOST_ORANGE_ACTIVATION ANN_ACTIVATION_SIGMOID 

#define PME_ANN_GHOST_OUTPUT            2

// EVNTrainer class implemented as a singleton
class EVNTrainer : public CMemPME
{
public:
    static EVNTrainer& Instance(); // Singleton accessor by object reference
    static void Terminate(); // Explicit singleton destruction
	
    Sint32 load(string& sGhostName, ArtificialNeuralNet* pNN, string& sCDCFile, string& sXMLName);
    Sint32 execute(GlobalStatus&, GameField&);

private:
    EVNTrainer();  // Heap-based and stack-based creation are forbidden.
    ~EVNTrainer(); // Inheritance is also forbidden.
    static EVNTrainer* mInstance;

    // Creature, in our case we ca have up to 4 (Red, Pink, Blue and Orange ghosts)
    struct Creature : public CMemPME
    {
    public:
        Sint32 info();

        Sint32 iID;
        Sint32 iGeneration;

        // Keep track of the best creature(s)
        Sint32 iBestCreatureGeneration;
        double dBestCreatureFitness;
        Sint32 iNumBestCreatures;
        vector<Genome> vBestCreaturesNN;

        // Brain's creature pointers
        vector<BrainEvolved*> vBrains;

        // Genetics algorithm
        GeneticAlgorithm* pGA;
        vector<Genome> vGenomesPopulation;

        // Constructor & Destructor
        Creature(Sint32);
        ~Creature();
    };
    vector<Creature*> vCreatures;

    // Methods
    Sint32 initCreatures(GlobalStatus& pGlobalStatus);
    Sint32 createDefaultANN(const string& sGhostName, string sCDCFile, string sXMLName);
    Sint32 saveCreatures(string sCDCFile, string sXMLName);
    Sint32 updateNode(XML* pXML, Creature* pCreature, Sint32 iNum);
    Sint32 parseWeights(char*, vector<double>&);
    
    // Genetics algorithm attributes common to all creatures    
    Sint32 iPopulation;
    double dMutationRate;
    double dCrossOverRate;
    double dMaxPerturbation;
    Sint32 iNumElite;
    Sint32 iNumCopiesElite;
};

#endif
