/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

Brains Factory class

------------------------------------------------------------------------ */

#ifndef OBJECTSBRAINSFACTORYPME_H
#define OBJECTSBRAINSFACTORYPME_H

#define PME_BRAIN_HIGHLEVEL_TARGET 1
#define PME_BRAIN_IMMEDIATE_TARGET 2
#define PME_BRAIN_TYPE_DISABLED
#define PME_BRAIN_TYPE_RANDOM   512
#define PME_BRAIN_TYPE_FIXED    1024
#define PME_BRAIN_TYPE_EVOLVED  2048
#define PME_BRAIN_TYPE_HUMAN    4096
#define PME_BRAIN_TYPE_TRAINING0    0x2000 // Bit 14(8192) upwards set the training id
#define PME_BRAIN_TYPE_TRAINING1    0x4000 
#define PME_BRAIN_TYPE_TRAINING2    0x8000 
#define PME_BRAIN_TYPE_TRAINING3    0x10000 
#define PME_BRAIN_TYPE_TRAINING4    0x20000 
#define PME_BRAIN_TYPE_TRAINING5    0x40000 
#define PME_BRAIN_TYPE_TRAINING6    0x80000 
#define PME_BRAIN_TYPE_TRAINING7    0x100000 
#define PME_BRAIN_TYPE_TRAINING8    0x200000 
#define PME_BRAIN_TYPE_TRAINING9    0x400000 
#define PME_BRAIN_TYPE_TRAINING10   0x800000
#define PME_BRAIN_TYPE_TRAINING11   0x1000000
#define PME_BRAIN_TYPE_TRAINING12   0x2000000
#define PME_BRAIN_TYPE_TRAINING13   0x4000000
#define PME_BRAIN_TYPE_TRAINING14   0x8000000

// Includes and forward definitions
#include "MemoryManager.h"
class Actor;
class Brain;
class EVNTrainer;
class GameField;

// Brain Factory class implemented as a singleton
class BrainsFactory : public CMemPME
{
public:
    static BrainsFactory& Instance(); // Singleton accessor by object reference
    static void Terminate(); // Explicit singleton destruction
    
    Sint32 think(Actor*, Sint32, Sint32&, Sint32&, GameField*);
    bool validate(Sint32);
    Sint32 getName(Sint32, string&);
    Sint32 getTargetType(Sint32);
    Brain* getBrain(Sint32);

private:
    explicit BrainsFactory(); // Heap-based and stack-based creation are forbidden.
    ~BrainsFactory(); // Inheritance is also forbidden.
    static BrainsFactory* mInstance;

    unordered_map<Sint32, Brain*> mapBrains;
};
#endif
