/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

Objects brain classes.

------------------------------------------------------------------------ */

#ifndef OBJECTSBRAINSPME_H
#define OBJECTSBRAINSPME_H

// Includes and forward definitions
#include "MemoryManager.h"
class GameField;
class Actor;
class ArtificialNeuralNet;

// --- Base Brain ---
class Brain : public CMemPME
{
public:
    explicit Brain();
    virtual ~Brain();
    virtual Sint32 think(Actor*, Sint32&, Sint32&, GameField*);
    void getName(string &);
    Sint32 getTargetType();
    
protected:
    string sName;
    Sint32 iTargetType;
};

// --- Evolved brain ---
class BrainEvolved : public Brain
{
public:
    explicit BrainEvolved();
    ~BrainEvolved();
    virtual Sint32 think(Actor*, Sint32&, Sint32&, GameField*) = 0;
    Sint32 load(string sCDCFile = "", string sXMLName = "");
    Sint32 setFitness(float);
    float getFitness();
    ArtificialNeuralNet* getNeuralNet();
protected:
    ArtificialNeuralNet* pNeuralNet;
    Sint32 iNNInput, iNNOutput;
    float fFitness;
};

// Brains for PacMan
class BrainPacManHuman : public Brain
{
public:
    explicit BrainPacManHuman();
    Sint32 think(Actor*, Sint32&, Sint32&, GameField*);
};
class BrainPacMan : public Brain
{
public:
    explicit BrainPacMan();
    Sint32 think(Actor*, Sint32&, Sint32&, GameField*);
};

// Brains for Red Ghost
class BrainRedGhost : public Brain
{
public:
    explicit BrainRedGhost();
    Sint32 think(Actor*, Sint32&, Sint32&, GameField*);
};
class BrainEvolvedRedGhost : public BrainEvolved
{
public:
    explicit BrainEvolvedRedGhost(Sint32);
    Sint32 think(Actor*, Sint32&, Sint32&, GameField*);
};

// Brains for Pink Ghost
class BrainPinkGhost : public Brain
{
public:
    explicit BrainPinkGhost();
    Sint32 think(Actor*, Sint32&, Sint32&, GameField*);
};
class BrainEvolvedPinkGhost : public BrainEvolved
{
public:
    explicit BrainEvolvedPinkGhost(Sint32);
    Sint32 think(Actor*, Sint32&, Sint32&, GameField*);
};

// Brains for Blue Ghost
class BrainBlueGhost : public Brain
{
public:
    explicit BrainBlueGhost();
    Sint32 think(Actor*, Sint32&, Sint32&, GameField*);
};
class BrainEvolvedBlueGhost : public BrainEvolved
{
public:
    explicit BrainEvolvedBlueGhost(Sint32);
    Sint32 think(Actor*, Sint32&, Sint32&, GameField*);
};

// Brains for Orange Ghost
class BrainOrangeGhost : public Brain
{
public:
    explicit BrainOrangeGhost();
    Sint32 think(Actor*, Sint32&, Sint32&, GameField*);
};
class BrainEvolvedOrangeGhost : public BrainEvolved
{
public:
    explicit BrainEvolvedOrangeGhost(Sint32);
    Sint32 think(Actor*, Sint32&, Sint32&, GameField*);
};


#endif
