/*----------------------------------------------------------------------
Pac-Man Evolution - Roberto Prieto
 Copyright (C) 2018-2025 MegaStorm Systems
contact@megastormsystems.com - http://www.megastormsystems.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

------------------------------------------------------------------------

Artificial Neural Network class

Based on the amazing docs created by Mat Buckland (http://www.ai-junkie.com/ann/evolved/nnt1.html)

------------------------------------------------------------------------ */

#ifndef ARTIFICIALNEURALNET_H
#define ARTIFICIALNEURALNET_H

// Includes and forward definitions
#include "MemoryManager.h"

// Enable or disable Bias
// https://stackoverflow.com/questions/2480650/role-of-bias-in-neural-networks
//#define ANN_ENABLE_BIAS

// Activation function
#define ANN_ACTIVATION_LINEAR   0
#define ANN_ACTIVATION_STEP     1
#define ANN_ACTIVATION_SIGMOID  2

// Weight interval and precision
#define ANN_WEIGHT_MIN -2
#define ANN_WEIGHT_MAX 2
#define ANN_PRECISION 0.000001f

// Function for generating random weights in [ANN_WEIGHT_MIN, ANN_WEIGHT_MAX] with ANN_PRECISION
float generateWeights(float fMin = ANN_WEIGHT_MIN, float fMax = ANN_WEIGHT_MAX);
// Function for applying ANN_PRECISION
float applyWeightPrecision(float);

// Neuron struct
struct Neuron
{
	// The number of inputs into the neuron
	Sint32 iNumInputs;

	// The weights for each input
	vector<double>	vWeight;

	// Constructor
	Neuron(Sint32 NumInputs);
};

// Layer of neurons
struct NeuronLayer
{
	// The number of neurons in this layer
	Sint32 iNumNeurons;

	// The layer of neurons
	vector<Neuron>	vNeurons;

	NeuronLayer(Sint32, Sint32);
};

// Artificial Neural Network class
class ArtificialNeuralNet
{
public:
	ArtificialNeuralNet();
	void init(Sint32, Sint32, Sint32, Sint32);

    // Activation function
    void setActivationFunction(Sint32);
    Sint32 getActivationFunction();

	// Gets the weights from the NN
	vector<double> getWeights();

	// Get neural network components
	Sint32 getNumOutputs();
	Sint32 getNumInputs();
	Sint32 getNumHiddenLayers();
	Sint32 getNumNeuronsPerLayer();

	// Returns total number of weights in net
	Sint32 getNumberOfWeights();

	// Replaces the weights with new ones
	Sint32 setWeights(vector<double> &vW);

	// Calculates the outputs from a set of inputs
	vector<double> update(vector<double> &inputs);

private:
    Sint32 iActivationFunc;
    Sint32 iNumInputs;
    Sint32 iNumOutputs;
    Sint32 iNumHiddenLayers;
    Sint32 iNeuronsPerHiddenLyr;

    // Storage for each layer of neurons including the output layer
    vector<NeuronLayer> vNeuronsLayers;

    // Activation functions:    
    inline double sigmoid(double, double);  // Sigmoid response curve    
    inline double linear(double, double);   // Linear    
    inline double step(double, double);     // Step
};

#endif