﻿# CRM64Pro GDK  
**A modern, hardware-accelerated C++ Game Development Kit built on SDL3**  

Copyright (C) 2013–2026 
Developed by Roberto Prieto – MegaStorm Systems  
https://www.megastormsystems.com

**CRM64Pro** is a modern, lightweight and hardware-accelerated C++17 Game Development Kit built on top of **SDL3**.
It provides a clean, modular architecture for creating 2D games, tools, and interactive applications, combining low-level control with high performance and cross-platform support.

CRM64Pro is distributed under the zlib license.

---

## 🚀 Key features

### **Modern core**
- Written in **C++17**  
- Built on **SDL3**  
- Multi-threaded architecture (audio, networking, timers, etc.)  
- Proprietary **CDC asset compression**  
- Integrated **EditorC64 resource editor**  
- Lightweight, modular subsystems  
- High-performance logging utilities  

### **Complete toolset**
- **Tile Engine (MSTE)** with full **[Tiled](https://www.mapeditor.org/)** (.tmx/.tsx) support  
- **GUI system** with windows, widgets, panels and layout management  
- **Sprite engine** with animation support and planned integration with **[Spine2D](https://esotericsoftware.com/)**  
- Data formats: XML, CDC packs, images, audio files, maps  
- Utility modules: memory manager, configuration system, timers, RNG, XML parsing, etc.

### **Hardware-Accelerated graphics**
Supported GPU backends (platform dependent):
- Direct3D 9 / 11 / 12  
- Vulkan  
- Metal (macOS)
- GPU
- OpenGL / OpenGL ES  

---

## 🖥️ Supported platforms

| Platform | Render drivers | Audio drivers |
|---------|-----------|--------|
| **Windows 7/10/11 (x64)** | Direct3D 9/11/12, Vulkan, GPU, OpenGL, Software | WASAPI, DirectSound |
| **Linux x64 (Kernel 4.18+)** | Vulkan, GPU, OpenGL, X11, Wayland, Software | ALSA, PulseAudio |
| **Android 5.0+** | OpenGL ES, Vulkan | AAudio, OpenSL ES |
| **macOS 10.13+** | Metal, Vulkan, GPU, OpenGL, software | CoreAudio |

---

## 📦 Installation

### **Windows (Visual Studio 2022+)**

CRM64Pro for Windows is distributed as a standard executable installer (created with **Inno Setup**):

**CRM64Pro-X.Y.Z-win-x64.exe**

The installer also includes **[EditorC64](https://www.megastormsystems.com/gdks/crm64pro-gdk/editorc64)**, the official resource editor for CRM64Pro.


1. Run the installer and choose an installation directory  
   (for example: `C:\Libs\CRM64Pro`).
2. Add the `include/` and `lib/` directories to your Visual Studio project.
3. Link against one of the following libraries:
   - `CRM64Pro.lib` — Dynamic linking  
   - `CRM64Pro.static.lib` — Static linking (Release)  
   - `CRM64Pro.static-debug.lib` — Static linking with debug information
4. If using dynamic linking, ensure `CRM64Pro.dll` is located next to your executable or accessible through the system `PATH`.

---

### **Linux (GCC 13+)**

CRM64Pro is provided as a self-extracting Bash installer:

```bash
chmod +x CRM64Pro-X.Y.Z-linux-x64.sh
sudo ./CRM64Pro-X.Y.Z-linux-x64.sh
```

This installs headers and libraries into standard system locations.

Compile and link using:
```bash
g++ main.cpp -o mygame -lCRM64Pro
```

---

### **macOS (Clang 12+)**

CRM64Pro is distributed as a DMG package containing a universal library supporting both x86_64 and arm64 (Apple Silicon).

1. Open the DMG and run the installer.

2. Headers and libraries are installed into standard system paths.

Compile from the terminal or configure Xcode normally:

```bash
clang++ main.cpp -o mygame -lCRM64Pro
```	

---

## 🔌 Third-Party libraries

CRM64Pro integrates several high-quality third-party libraries supporting audio, image formats, compression, memory allocation, XML parsing and more.

| Library | Purpose | URL |
|--------|---------|-----|
| **AES (Gladman)** | Encryption routines | http://www.gladman.me.uk/ |
| **dr_flac** | FLAC audio decoding | https://github.com/mackron/dr_libs |
| **dr_mp3** | MP3 audio decoding | https://github.com/mackron/dr_libs |
| **libpng** | PNG image support | http://www.libpng.org/pub/png/libpng.html |
| **libxmp** | Module audio playback (MOD/XM/etc.) | https://github.com/libxmp/libxmp |
| **ltalloc** | Lightweight memory allocator | https://github.com/r-lyeh-archived/ltalloc |
| **MT RNG** | Mersenne Twister random generator | http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/emt.html |
| **SDL3** | Core cross-platform framework | https://libsdl.org |
| **SDL3_mixer** | Audio mixing library | https://www.libsdl.org/projects/SDL_mixer |
| **SDL2_gfx** | 2D drawing primitives | http://www.ferzkopp.net/wordpress/ |
| **SDL2_image** | Image loading support | https://www.libsdl.org |
| **SDL2_net** | Networking support | https://www.libsdl.org/projects/SDL_net |
| **stb_vorbis** | Ogg Vorbis decoder | https://github.com/nothings/stb |
| **TinyXML2** | XML parsing library | http://www.grinninglizard.com/tinyxml2/ |
| **xxHash** | High-speed hashing | https://cyan4973.github.io/xxHash/ |
| **zlib-ng** | Compression engine | https://github.com/zlib-ng/zlib-ng |

All third-party licenses are included in the `/licenses` directory of the distribution.

---

## 📚 Documentation

CRM64Pro includes a complete **Doxygen-based API Reference**, providing detailed coverage of all engine modules, including:

- Engine architecture and subsystem overview  
- Game loop strategies (variable, fixed, interpolated)  
- Sprite and animation systems  
- Tile Engine (MSTE) and GUI framework  
- Audio playback and resource handling  
- Asset management (CDC packs, images, XML, etc.)  
- Practical code examples and recommended best practices  

The full documentation is bundled with every release under the `/docs` directory, and is also available online:

https://www.megastormsystems.com/repository/CRM64Pro/docs/index.html

---

## 📝 License

CRM64Pro is distributed under the **zlib license**, allowing use in commercial and open-source projects with minimal restrictions.

Please ensure that **all third-party library licenses** included in `/licenses` are preserved in your distributions.
